/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.client.PIFoDCodeInfoDataBean;
import com.ibm.hsc.client.PIFoDDataBean;
import com.ibm.hsc.client.PIFoDHistLogEntryDataBean;
import com.ibm.hsc.client.PIFoDKeyDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCFoDClient;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIHscFoDCIMClient
extends HSCCIMClient
implements PIHSCFoDClient {
    private static final String MOF_FOD_TYPE = "FoDType";
    private static final String MOF_CONFIRMATION_PARM = "ConfirmationParam";
    private static final String MOF_CONFIRMATION_ID = "ConfirmationID";
    private static final String MOF_COD_KEY = "FoDKey";
    private static final String MOF_FOD_RECOVERY_COMPLETE_VALUE = "CodRecoveryCompleteValue";

    private PIHscFoDCIMClient(String string, String string2, CIMObjectPath cIMObjectPath, String string3) {
        super(string, null, string2, cIMObjectPath, string3);
    }

    private void debug(String string) {
        if (IDebug.enabled) {
            System.err.println("| FoD.Client." + string);
        }
    }

    public static PIHscFoDCIMClient createInstance(String string, String string2, boolean bl) throws PIHscClientException {
        System.err.println("in createInstance()");
        return PIHscFoDCIMClient.createInstance(string, string2, bl, "root/ibmhscS1_0");
    }

    public static PIHscFoDCIMClient createInstance(String string, String string2, boolean bl, String string3) throws PIHscClientException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", string3);
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string, cIMObjectPath, true);
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            String string4 = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, "Name");
                string4 = (String)cIMValue.getValue();
                if (string2.equals(string4)) {
                    cIMObjectPath3 = cIMObjectPath4;
                    if (bl) break;
                }
                if (bl || !string2.equals((String)(cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, "UserDefinedName")).getValue())) continue;
                cIMObjectPath2 = cIMObjectPath4;
                break;
            }
            if (cIMObjectPath2 == null && cIMObjectPath3 == null) {
                return null;
            }
            if (cIMObjectPath2 == null) {
                string4 = string2;
            } else {
                cIMObjectPath3 = cIMObjectPath2;
            }
            return new PIHscFoDCIMClient(string, string4, cIMObjectPath3, string3);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void printVectorValues(Vector vector) {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                this.debug("vector[" + i + "] value=" + vector.elementAt(i));
            }
        }
    }

    public static PIHscFoDCIMClient createInstance(PIHSCCECClient pIHSCCECClient) throws PIHscClientException {
        String string = pIHSCCECClient.getHostName();
        CIMObjectPath cIMObjectPath = pIHSCCECClient.getObjectPath();
        String string2 = pIHSCCECClient.getIntName();
        String string3 = cIMObjectPath.getNameSpace();
        return new PIHscFoDCIMClient(string, string2, cIMObjectPath, string3);
    }

    public PIFoDDataBean getFoDCapabilities() throws PIHscClientException {
        CIMInstance cIMInstance;
        this.debug("in getFoDCapabilities()");
        PIFoDDataBean pIFoDDataBean = new PIFoDDataBean();
        try {
            this.debug("getting cec cim instance");
            cIMInstance = this.getCIMInstance();
        }
        catch (HSCException hSCException) {
            this.debug("error getting cec cim instance");
            throw new PIHscClientException("05EB", "HSCCIMExceptionBundle", "05EB", null, hSCException);
        }
        try {
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)PIHscUtil.getCIMAttrValue(cIMInstance, "FoDCapabilities");
            byte[] byArray = ByteUtilities.intToByteArray(unsignedInt32.intValue());
            BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray);
            this.debug("FoD capanilities are=" + bitSet);
            pIFoDDataBean.setFoDCapability(bitSet);
        }
        catch (Exception exception) {
            PIHscClientException pIHscClientException = null;
            pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", null, null, exception);
            throw pIHscClientException;
        }
        return pIFoDDataBean;
    }

    public PIFoDCodeInfoDataBean GetFoDOrderInfo(int n) throws PIHscClientException {
        this.debug("in GetFoDOrderInfo(),fodType=" + n);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        PIFoDCodeInfoDataBean pIFoDCodeInfoDataBean = new PIFoDCodeInfoDataBean();
        try {
            int n2;
            vector.addElement(new CIMProperty(MOF_FOD_TYPE, new CIMValue((Object)new UnsignedInt8((short)n))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetFoDOrderInfo", vector, vector2);
            Vector vector3 = null;
            this.debug("outArgs values are=" + vector2.toString());
            if (vector2.elementAt(0) instanceof CIMValue) {
                n2 = ((UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue()).intValue();
                vector3 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
            } else {
                n2 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                vector3 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                this.debug("output values are=" + n2 + ", orderInfoList=" + vector3);
            }
            if (n2 == 1 && vector3 != null && vector3.size() > 0) {
                this.printVectorValues(vector3);
                pIFoDCodeInfoDataBean.setSysType((String)vector3.elementAt(0));
                pIFoDCodeInfoDataBean.setSysSerialNum((String)vector3.elementAt(1));
                pIFoDCodeInfoDataBean.setAnchorCardCcin((String)vector3.elementAt(2));
                pIFoDCodeInfoDataBean.setAnchorCardSerialNum((String)vector3.elementAt(3));
                pIFoDCodeInfoDataBean.setAnchorCardId((String)vector3.elementAt(4));
                pIFoDCodeInfoDataBean.setResourceId((String)vector3.elementAt(5));
                pIFoDCodeInfoDataBean.setActivatedResources((String)vector3.elementAt(6));
                pIFoDCodeInfoDataBean.setSequenceNumber((String)vector3.elementAt(7));
                pIFoDCodeInfoDataBean.setEntryCheck((String)vector3.elementAt(8));
            }
            this.debug("PIFoDCodeInfoDataBean values are=" + pIFoDCodeInfoDataBean);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pIFoDCodeInfoDataBean;
    }

    public PIFoDKeyDataBean setFoDKey(String string) throws PIHscClientException {
        this.debug("calling setFodKey()");
        return this.setFoDKey(255, 0, string);
    }

    public PIFoDKeyDataBean setFoDKey(int n, int n2, String string) throws PIHscClientException {
        PIFoDKeyDataBean pIFoDKeyDataBean = new PIFoDKeyDataBean();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            UnsignedInt8 unsignedInt8;
            vector.addElement(new CIMProperty(MOF_CONFIRMATION_PARM, new CIMValue((Object)new UnsignedInt8((short)n))));
            vector.addElement(new CIMProperty(MOF_CONFIRMATION_ID, new CIMValue((Object)new UnsignedInt16(n2))));
            vector.addElement(new CIMProperty(MOF_COD_KEY, new CIMValue((Object)string)));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "SetFoDKey", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                pIFoDKeyDataBean.setFoDType(((UnsignedInt32)((CIMValue)vector2.elementAt(0)).getValue()).intValue());
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector2.elementAt(1)).getValue();
                pIFoDKeyDataBean.setConfMsgID(Integer.toString(((UnsignedInt16)((CIMValue)vector2.elementAt(2)).getValue()).intValue()));
                pIFoDKeyDataBean.setKeyInfoMsg((String)((CIMValue)vector2.elementAt(3)).getValue());
            } else {
                pIFoDKeyDataBean.setFoDType(((UnsignedInt32)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue());
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                pIFoDKeyDataBean.setConfMsgID(Integer.toString(((UnsignedInt16)((CIMProperty)vector2.elementAt(2)).getValue().getValue()).intValue()));
                pIFoDKeyDataBean.setKeyInfoMsg((String)((CIMProperty)vector2.elementAt(3)).getValue().getValue());
            }
            if (unsignedInt8.intValue() == 1) {
                pIFoDKeyDataBean.setConfNeededVal(true);
            } else {
                pIFoDKeyDataBean.setConfNeededVal(false);
            }
            this.debug("PIFoDKeyDataBean values are=" + pIFoDKeyDataBean);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pIFoDKeyDataBean;
    }

    public void setFoDRecovery(int n) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.addElement(new CIMProperty(MOF_FOD_RECOVERY_COMPLETE_VALUE, new CIMValue((Object)new UnsignedInt8((short)((byte)n)))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "SetCodRecoveryComplete", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public Vector getFoDHistoryLog() throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector<PIFoDHistLogEntryDataBean> vector3 = new Vector<PIFoDHistLogEntryDataBean>();
        boolean bl = false;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt8 unsignedInt8 = null;
        try {
            Vector vector4;
            Vector vector5;
            Vector vector6;
            Vector vector7;
            Vector vector8;
            Vector vector9;
            Vector vector10;
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetFoDHistoryLog", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                bl = true;
            }
            if (bl) {
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue();
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector2.elementAt(1)).getValue();
                vector10 = (Vector)((CIMValue)vector2.elementAt(2)).getValue();
                vector9 = (Vector)((CIMValue)vector2.elementAt(3)).getValue();
                vector8 = (Vector)((CIMValue)vector2.elementAt(4)).getValue();
                vector7 = (Vector)((CIMValue)vector2.elementAt(5)).getValue();
                vector6 = (Vector)((CIMValue)vector2.elementAt(6)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(7)).getValue();
                vector4 = (Vector)((CIMValue)vector2.elementAt(8)).getValue();
            } else {
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                vector10 = (Vector)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                vector9 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                vector8 = (Vector)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(7)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector2.elementAt(8)).getValue().getValue();
            }
            PIFoDHistLogEntryDataBean[] pIFoDHistLogEntryDataBeanArray = new PIFoDHistLogEntryDataBean[unsignedInt16.intValue()];
            int n = 0;
            for (int i = 0; i < unsignedInt16.intValue(); ++i) {
                if ((String)vector10.elementAt(i) == null) continue;
                pIFoDHistLogEntryDataBeanArray[n] = new PIFoDHistLogEntryDataBean();
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryText = (String)vector10.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryTimestampYear = (UnsignedInt16)vector9.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryTimestampMonth = (UnsignedInt8)vector8.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryTimestampDay = (UnsignedInt8)vector7.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryTimestampHour = (UnsignedInt8)vector6.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryTimestampMinute = (UnsignedInt8)vector5.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logEntryTimestampSecond = (UnsignedInt8)vector4.elementAt(i);
                pIFoDHistLogEntryDataBeanArray[n].m_logWrapVal = unsignedInt8;
                vector3.addElement(pIFoDHistLogEntryDataBeanArray[n]);
                ++n;
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return vector3;
    }
}

